-- by viewing this file you have seen too much.
-- by reading both this and the above comment you have seen too much.

--[[
hi, all that's left are the combo milestones that Midiman implemented already.
make them unique.
]]

local c, tc;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

-- :ssh:
local UseToastyMeter = (PREFSMAN:GetPreference("EasterEggs") == 0) and false or THEME:GetMetric("Combo","ShowToastyMeter");
local toastyCombo = 0;
local toastyBarWidth = 128;
local toastyBarHeight = 8;
local numlblOffset = 12;
-- local numToasties = 0;

local t = Def.ActorFrame {
	AutoText("blaster_shiny") .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	AutoText("blaster_shiny") .. {
		Name="Number2";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadActor( HDActor("label") ) .. {
		Name="ComboLabel";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};

	Def.ActorFrame{
		Name="ToastyMeter";

		Def.Quad{
			Name="ToastyMeterBG";
			InitCommand=cmd(zoomto,toastyBarWidth+2,toastyBarHeight+2;y,numlblOffset*3.16667;vertalign,bottom;diffuse,color("#000000");diffusebottomedge,color("#444444"));
		};

		Def.Quad{
			Name="50pctMarker";
			InitCommand=cmd(zoomto,1,toastyBarHeight+2;y,numlblOffset*2.75;diffuse,color("1,1,1,0.5"));
		};

		Def.Quad{
			Name="ToastyMeterFill";
			InitCommand=cmd(zoomto,0,toastyBarHeight;x,-(toastyBarWidth/2);y,numlblOffset*3.125;vertalign,bottom;horizalign,left;diffusebottomedge,PlayerColor(player));
		};
	};

	InitCommand = function(self)
		self:draworder(101);
		c = self:GetChildren();
		c.Number:visible(false);
		c.ComboLabel:visible(false);
		c.ToastyMeter:visible(false);

		tc = c.ToastyMeter:GetChildren();
		-- you know, just in case something happens.
		--numToasties = 0;
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:visible(false);
			c.Number2:visible(false);
			c.ComboLabel:visible(false);
			c.ToastyMeter:visible(false);
			return;
		end

		local Label = c.ComboLabel;
		local bComboOrMiss = false;
		local bMiss = false;

		if param.Combo then
			Label:diffusebottomedge( PlayerColor(player) );
			bComboOrMiss = true;
			bMiss = false;
		elseif param.Misses then
			Label:diffusebottomedge( color("#FF0000") );
			bComboOrMiss = true;
			bMiss = true;
		end
		Label:visible(false);

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		if bComboOrMiss then
			c.Number:visible(true);
			c.Number2:visible(true);
			Label:visible(true);

			-- don't show the toasty meter if it's not enabled
			-- or during miss streams.
			if UseToastyMeter and not bMiss then
				c.ToastyMeter:visible(true);
			end;
		end;

		c.Number:settext( string.format("%i", iCombo) );
		c.Number:diffuse( PlayerColor(player) );
		c.Number:diffusebottomedge( PlayerMidColor(player) );

		-- set up the add
		c.Number2:settext( string.format("%i", iCombo) );
		c.Number2:diffuse( PlayerColor(player) );
		c.Number2:blend('BlendMode_Add');
		c.Number2:diffusealpha(0.1); -- was 0.15

		-- this function glows the combo number.
		local Pulse = function(self)
			self:stoptweening();

			local GlowStart;
			local GlowEnd;
			local StartAlpha = 0.5;
			if param.Combo then
				GlowColor = color("1,1,1,"..StartAlpha);
				GlowEnd = color("1,1,1,0");
			else
				GlowColor = color("1,0,0,"..StartAlpha);
				GlowEnd = color("1,0,0,0");
			end;

			self:glow(GlowColor);
			self:zoom(1.05);
			self:smooth(0.1);
			self:glow(GlowEnd);
			self:zoom(1.0);
		end;
		
		Pulse( c.Number, param );
	end;

	JudgmentMessageCommand=function(self, param)
		if param.Player ~= player then return end;
		if not param.TapNoteScore then return end;
		if not UseToastyMeter then return end;
		local tns = param.TapNoteScore;

		if tns == 'TapNoteScore_W1' or tns == 'TapNoteScore_W2' then
			toastyCombo = toastyCombo + 1;
		else
			toastyCombo = 0;
		end;

		tc.ToastyMeterFill:zoomx( (toastyCombo/250) * toastyBarWidth );

		-- reset the toasty combo every 250 successful toasty combo steps.
		if toastyCombo >= 250 then
			--numToasties = numToasties + 1;
			-- any toasties past the first one aren't played.
			--if numToasties >= 1 then
				--SCREENMAN:GetTopScreen():PostScreenMessage("SM_PlayToasty")
			--end;
			toastyCombo = 0;
		end;
	end;
};

return t;
-- you've seen too much!